package net.xdevelop.taglib.page;

import javax.servlet.jsp.tagext.*;
import javax.servlet.jsp.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.util.*;
import java.net.URLEncoder;
import java.io.IOException;
import net.xdevelop.util.*;

/**
 * ʾ,ô˸ıÿҳļ¼,·ҳҳ
 * ʹ÷:<page:navigator type='BUTTON'/>
 * @author Starboy
 * @version 2.0
 */
public class NavigatorTag extends TagSupport {
    /**(BUTTON/TEXT)(ť/)*/
    private String type = "BUTTON"; //ѡ񵼺Ĭ"BUTTON"(BUTTON/TEXT)

    public void setType(String newType) {
        type = newType;
    }

    public int doStartTag() throws JspException {
        try {
            String bar = getNavigatorBar(type);
            pageContext.getOut().write(bar);
            return SKIP_BODY;
        }
        catch (IOException ioe) {
            throw new JspException(ioe.getMessage());
        }
    }

    public int doEndTag() throws JspException {

        return EVAL_PAGE;

    }

    /**
     * ָͻõԤƵĵ
     * @param type (BUTTON/TEXT)
     * @return صHTML,ָͲ,""
     */
    private String getNavigatorBar(String type) {
        String bar = "";
        String pageNo   = ((Integer) pageContext.getAttribute("pageNo")).toString();
        String pages    = ((Integer) pageContext.getAttribute("pages")).toString();
        String total    = ((Integer) pageContext.getAttribute("total")).toString();
        String pageSize = ((Integer) pageContext.getAttribute("pageSize")).toString();
        String nextDisabled = "";
        String prevDisabled = "";
        if (Integer.parseInt(pageNo) >= Integer.parseInt(pages))
            nextDisabled = "disabled";
        if (Integer.parseInt(pageNo) <= 1)
            prevDisabled = "disabled";

        //---------------------ť͵ĵ-----------------------//
        if (type.equalsIgnoreCase("BUTTON")) {
            String pageSizeInput = "<input type='text' size='2' value='" + pageSize + "' "
                                   + "onChange=\"javascript:this.form.choice.value='current';"
                                   + "this.form.pageSize.value=this.value;this.form.submit();\">";
            String firstButton = "<input type='button' value='  ҳ' " + prevDisabled + " "
                                 +
                    "onClick=\"javascript:this.form.choice.value='first';this.form.submit();\">";
            String prevButton = "<input type='button' value='һҳ' " + prevDisabled + " "
                                +
                    "onClick=\"javascript:this.form.choice.value='prev';this.form.submit();\">";
            String nextButton = "<input type='button' value='һҳ' " + nextDisabled + " "
                                +
                    "onClick=\"javascript:this.form.choice.value='next';this.form.submit();\">";
            String lastButton = "<input type='button' value='һҳ' " + nextDisabled + " "
                                +
                    "onClick=\"javascript:this.form.choice.value='last';this.form.submit();\">";
            String pageNoInput = "<input type='text' size='3' value='" + pageNo + "' "
                                 + "onChange=\"javascript:this.form.pageNo.value=this.value\">";

            bar = "ÿҳpageSize¼ | \n"
                  + "pagesҳ/total¼ | \n"
                  + "first \n prev \n next \n last \n | pageNoҳ\n"
                  +
                    " <input type='submit' value='go' onClick=\"javascript:this.form.choice.value='current';\">\n";

            bar = StringUtil.replace(bar, "pageSize", pageSizeInput);
            bar = StringUtil.replace(bar, "pages", pages);
            bar = StringUtil.replace(bar, "total", total);
            bar = StringUtil.replace(bar, "first", firstButton);
            bar = StringUtil.replace(bar, "prev", prevButton);
            bar = StringUtil.replace(bar, "next", nextButton);
            bar = StringUtil.replace(bar, "last", lastButton);
            bar = StringUtil.replace(bar, "pageNo", pageNoInput);
        } /////end of if(button)

        //-----------------------------------------------------//
        if (type.equalsIgnoreCase("TEXT")) {
            String pageSizeInput = "<input type='text' size='2' value='" + pageSize + "' "
                                   + "onChange=\"document.pager.choice.value='current';"
                                   + "this.form.pageSize.value=this.value;this.form.submit();\">";
            String firstText = "  ҳ";
            String prevText = "һҳ";
            String nextText = "һҳ";
            String lastText = "һҳ";
            if (prevDisabled.equalsIgnoreCase("")) {
                firstText = "<a href='first' "
                            +
                        "onClick=\"javascript:document.pager.choice.value='first';document.pager.submit();return false;\">"
                            + "  ҳ"
                            + "</a>";
                prevText = "<a href='prev' "
                           +
                        "onClick=\"javascript:document.pager.choice.value='prev';document.pager.submit();return false;\">"
                           + "һҳ"
                           + "</a>";
            }
            if (nextDisabled.equalsIgnoreCase("")) {
                nextText = "<a href='next' "
                           +
                        "onClick=\"javascript:document.pager.choice.value='next';document.pager.submit();return false;\">"
                           + "һҳ"
                           + "</a>";
                lastText = "<a href='last' "
                           +
                        "onClick=\"javascript:document.pager.choice.value='last';document.pager.submit();return false;\">"
                           + "һҳ"
                           + "</a>";
            }
            String pageNoInput = "<input type='text' size='3' size='2' value='" + pageNo + "' "
                                 + "onChange=\"javascript:this.form.pageNo.value=this.value\">";

            bar = "ÿҳpageSize¼ | \n"
                  + "pagesҳ/total¼ | \n"
                  + "first \n prev \n next \n last \n | pageNoҳ\n"
                  +
                    " <input type='submit' value='go' onClick=\"javascript:this.form.choice.value='current';\">\n";

            bar = StringUtil.replace(bar, "pageSize", pageSizeInput);
            bar = StringUtil.replace(bar, "pages", pages);
            bar = StringUtil.replace(bar, "total", total);
            bar = StringUtil.replace(bar, "first", firstText);
            bar = StringUtil.replace(bar, "prev", prevText);
            bar = StringUtil.replace(bar, "next", nextText);
            bar = StringUtil.replace(bar, "last", lastText);
            bar = StringUtil.replace(bar, "pageNo", pageNoInput);
        } /////end of if(text)

        //---------------------ť͵ĵ-----------------------//
        if (type.equalsIgnoreCase("SIMPLEBUTTON")) {
            String pageSizeInput = "<input class='navbar' type='text' size='1' value='" + pageSize +
                                   "' "
                                   + "onChange=\"javascript:this.form.choice.value='current';"
                                   + "this.form.pageSize.value=this.value;this.form.submit();\">";
            String prevButton = "<input class='navbar' type='button' value='һҳ' " + prevDisabled +
                                " "
                                +
                    "onClick=\"javascript:this.form.choice.value='prev';this.form.submit();\">";
            String nextButton = "<input class='navbar' type='button' value='һҳ' " + nextDisabled +
                                " "
                                +
                    "onClick=\"javascript:this.form.choice.value='next';this.form.submit();\">";
            String pageNoInput = "<input class='navbar' type='text' size='1' value='" + pageNo +
                                 "' "
                                 + "onChange=\"javascript:this.form.pageNo.value=this.value\">";

            bar = "ÿҳpageSize¼ | \n"
                  + "pagesҳ/total¼ | \n"
                  + "\n prev \n next \n | pageNoҳ\n"
                  + " <input class='navbar' type='submit' value='go' onClick=\"javascript:this.form.choice.value='current';\">\n";

            bar = StringUtil.replace(bar, "pageSize", pageSizeInput);
            bar = StringUtil.replace(bar, "pages", pages);
            bar = StringUtil.replace(bar, "total", total);
            bar = StringUtil.replace(bar, "prev", prevButton);
            bar = StringUtil.replace(bar, "next", nextButton);
            bar = StringUtil.replace(bar, "pageNo", pageNoInput);
        } /////end of if(button)

        //-----------------------------------------------------//
        if (type.equalsIgnoreCase("SIMPLETEXT")) {
            String pageSizeInput = "<input type='text' size='1' value='" + pageSize + "' "
                                   + "onChange=\"javascript:document.pager.choice.value='current';"
                                   + "this.form.pageSize.value=this.value;this.form.submit();\">";
            String firstText = "  ҳ";
            String prevText = "һҳ";
            String nextText = "һҳ";
            String lastText = "һҳ";
            if (prevDisabled.equalsIgnoreCase("")) {
                firstText = "<a href='first' "
                            +
                        "onClick=\"javascript:document.pager.choice.value='first';document.pager.submit();return false;\">"
                            + "  ҳ"
                            + "</a>";
                prevText = "<a href='prev' "
                           +
                        "onClick=\"javascript:document.pager.choice.value='prev';document.pager.submit();return false;\">"
                           + "һҳ"
                           + "</a>";
            }
            if (nextDisabled.equalsIgnoreCase("")) {
                nextText = "<a href='next' "
                           +
                        "onClick=\"javascript:document.pager.choice.value='next';document.pager.submit();return false;\">"
                           + "һҳ"
                           + "</a>";
                lastText = "<a href='last' "
                           +
                        "onClick=\"javascript:document.pager.choice.value='last';document.pager.submit();return false;\">"
                           + "һҳ"
                           + "</a>";
            }
            String pageNoInput = "<input type='text' size='1' value='" + pageNo + "' "
                                 + "onChange=\"javascript:this.form.pageNo.value=this.value\">";

            bar = "ÿҳpageSize¼ | \n"
                  + "pagesҳ/total¼ | \n"
                  + "prev \n next \n | pageNoҳ\n"
                  +
                    " <input type='submit' value='go' onClick=\"javascript:this.form.choice.value='current';\">\n";

            bar = StringUtil.replace(bar, "pageSize", pageSizeInput);
            bar = StringUtil.replace(bar, "pages", pages);
            bar = StringUtil.replace(bar, "total", total);
            bar = StringUtil.replace(bar, "prev", prevText);
            bar = StringUtil.replace(bar, "next", nextText);
            bar = StringUtil.replace(bar, "pageNo", pageNoInput);
        } /////end of if(text)
        return bar;
    }
}